### WORKING DIRECTORY ###
# You can find your working directory using the function getwd()
# The path of the directory that R is currently using will be displayed in the console
# You can change the working directory using the setwd() function, giving the directory path as the argument
# The working directory should be where this R file and any required data files are stored 
# For example setwd("C:/Users/Username/Documents")

getwd()
setwd(" ... ")

### PACKAGES ###
# Packages only need to be installed once using install.packages()
# Packages should be loaded using library() in every session

library(tidyverse)
library(openxlsx)
library(network)
library(igraph)
library(intergraph)
library(GGally)
library(sna) 

### READ IN DATA ###

edges <- read.xlsx("Redes de semillas.xlsx", sheet="aristas")
nodes <- read.xlsx("Redes de semillas.xlsx", sheet="nodos")

### MANIPULATE DATA ###
# Combine labels of nodes with edges

edges1 <- edges %>%
              inner_join(
                select(nodes,"Id","from"="Label"), by=c("Source"="Id")
                ) %>%
              inner_join(
                select(nodes,"Id","to"="Label"), by=c("Target"="Id")
                )
              

# Removes edeges that are loops
edges2 <- filter(edges1, from!=to)

# Filter the estrategias
estlocal<-edges2 %>%
          filter(Estrategia %in% c("Acuerdos","Pago en especie", "Compra y venta", "Herencia", "Intercambio", "Regalo", "Robo"))
 
### CREATE THE BASIC NETWORK ###

net = network(dplyr::select(estlocal,"from","to"), directed = TRUE, multiple=TRUE)

### ADD ADDITIONAL VARIABLES ###
# Create the dataframe of nodes that coincide with the list of edges in the network

nodes1 <- data.frame(Node = network.vertex.names(net)) %>%
            mutate(Node=as.character(Node)) %>%
            full_join(nodes,by=c("Node"="Label"))

# Include node variables using %v%
# Include edge variables using %e%

net %v% "Actors" = as.character(nodes1$Actors)
net %e% "Estrategia" = as.character(estlocal$Estrategia)

net <- net %>%
        asIgraph()

### IMPROVE THE APPEARANCE OF THE GRAPH ####
# This code can be edited to change the appearance of the graph

unique(V(net)$Actors)
color1 <- c("turquoise","purple","grey","limegreen","#660033")
color_Actors<- color1[as.numeric(as.factor(V(net)$Actors))]

unique(E(net)$Estrategia)
color2 <- c("black","turquoise","orange","limegreen","blue","brown","purple")
color_Estrategia <- color2[as.numeric(as.factor(E(net)$Estrategia))]


# Graph

plot(net,
     main="Estrategia familiar",
     layout=layout.auto,             # Layout of the nodes
     edge.arrow.size=0.1,             # Size of the arrow
     edge.curved=0.7,                 # Curvature of the edges
     edge.color=color_Estrategia,    # Colour of the edges
     edge.width=0.8,                  # Width of the edges
     vertex.color=color_Actors,      # Colour of the nodes
     vertex.frame.color=color_Actors,# Colour of the outline of the nodes
     vertex.size=5,                  # Size of the node
     vertex.shape="sphere",          # Shape of the node
     vertex.label=NA                 # To not show node labels - set to NA)
)

legend("topleft",
       legend=levels(as.factor(V(net)$Actors)),
       col=color1,
       pt.bg=color1,
       pch=21,
       bty="n",
       title="ACTORES",
       title.col="black",
       title.adj=0.1,
       pt.cex= 1.4,
       cex=0.6,
       text.col=color1)

legend(x=-2.2, y =0.2,
       legend=levels(as.factor(E(net)$Estrategia)),
       lty=1,
       col=color2,
       bty="n",
       title="ESTRATEGIAS",
       title.col="black",
       title.adj=0.1,
       cex=0.6,
       text.col=color2)
